% MATLAB example using TCP/IP (matlab_tcpip_scpi_example.m)
% This simple code example demonstrates how you can use MATLAB to exchange data 
% with a remote application not developed in MATLAB. This code example is taken
% from a MATLAB Digest technical article written by Edward J. Mayhew from 
% George Mason University.  While HTTP was used as the higher-level protocol in 
% this example, you can use other protocols, as was the case in the project. 
% MATLAB supports TCP/IP using Instrument Control Toolbox.  Requires MATLAB and 
% Instrument Control Toolbox. 
%
% Copyright 2006 - 2014 The MathWorks, Inc.
%
% On line 19, substitute "meas:volt?" with the actual quiry, or non quiry command
% you want to test.
%
% On line 22, substitute "10.40.0.207" with the actual power supply with
% which you wish to communicate.

% Define a scpi command.
command = 'meas:volt?';

% Create TCP/IP object 't'. Specify power supply, port number and timeout. 
t = tcpip('10.40.0.207', 8462, 'Timeout', 2); 

% Set size of receiving buffer, if needed.
set(t, 'InputBufferSize', 200); 

% Open connection to the power supply.
fopen(t); 

% Transmit a scpi command to the power supply. Use fprintf(t, 'meas:volt?'); 
% to send a command without defining it first like in this example.
fprintf(t, command); 
   
% Pause for the communication delay.
pause(0.05);

if strfind(command,'?')
    fprintf('Answer of quiry command:');
    % Receive bytes of data from the power supply
    while (get(t, 'BytesAvailable') > 0) 
    t.BytesAvailable 
    DataReceived = fscanf(t) 
    end 
else
    fprintf('Set command: '); 
    fprintf(command);
end

% Disconnect and clean up the tcpip connection.
fclose(t); 
delete(t); 
clear t; 
