# Company:  Delta Elektronika B.V.
# Project:  EtherCAT Detection
# File:     EtherCAT_Detection.py
# Date:     02/06/2025

# This code is provided "as is" without any guarantees or warranties. Delta Elektronika B.V.
# is not responsible for any damages, losses, or issues arising from its use, implementation, or modification.

import pysoem


# Find all network adapters
adapters = pysoem.find_adapters()

# Go through all network adapters to find EtherCAT slaves.
for adapter in adapters:
    master = pysoem.Master()
    try:
        master.open(adapter.name)                                                                   # Try opening EtherCAT communication with current network adapter.
    except:
        continue                                                                                    # Skip adapter if EtherCAT communication is not possible.

    try:                                                                                            # If EtherCAT communication is possible:
        if master.config_init() > 0:
            for slave in master.slaves:                                                             # Go through all slaves.
                if slave.name == "Delta Elektronika: Anybus EtherCAT":                              # Filter for the slave with name "Delta Elektronika: Anybus EtherCAT".
                    print(f"Found PSC-ANY-EXT / INT-MOD-ANY that utilizes EtherCAT on network:")    # Print slave details:
                    print(f"* Adapter Name:         {adapter.name}")                                # ..
                    print(f"* Adapter Description:  {adapter.desc}\n")                              # ..

    finally:
        master.close()                                                                              # Close the EtherCAT communication.